
/**
 * Title:        FakeRMI implementation<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Joe Schwartz<p>
 * Company:      Alkindi, LLC<p>
 * @author Joe Schwartz
 * @version 1.0
 */
package Alkindi.RMITest;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.Naming.*;

public class RMITestSvr
{
	static final String gAppName = "RMITestServer";
	static public AccountManager m_AcctMgr;
	static public AdminManager m_AdminMgr;
	static public ClusterManager m_ClustMgr;
	static public RatingManager m_RatMgr;
	static public RecommendationManager m_RecMgr;
	static public SearchManager m_SearchMgr;

	public RMITestSvr()
	{
	}


	public static void main(String[] args)
	{

		if (System.getSecurityManager() == null) {
	    		System.setSecurityManager(new RMISecurityManager());
	      	}
		System.out.println(gAppName + "Instantiating objects.");
	       try {
			m_AcctMgr = new AccountManager();
			m_AdminMgr = new AdminManager();
	  		m_ClustMgr = new ClusterManager();
	    		m_RatMgr = new RatingManager();
	      		m_RecMgr = new RecommendationManager();
	        	m_SearchMgr = new SearchManager();
	 	}
	  	catch (Exception e) {
	   		System.out.println(gAppName + " error: " + e.getMessage());
	     		e.printStackTrace();
	       		return;
	       }
		System.out.print("Binding to RMI registry.\n");

	       try {
	       		Naming.rebind("AcctMgr", m_AcctMgr);
          		Naming.rebind("AdminMgr", m_AdminMgr);
            		Naming.rebind("RatMgr", m_RatMgr);
              		Naming.rebind("RecMgr", m_RecMgr);
                	Naming.rebind("SearchMgr", m_SearchMgr);
	       }
	       catch (Exception e) {
	       		System.out.println(gAppName + " error: " + e.getMessage());
	         	e.printStackTrace();
	          	return;
	       }
        	System.out.print(gAppName + " Main() done.");
	}
}